function mesh = setlengthscale( mesh )
%mesh = setlengthscale( mesh )    Set mesh.globalProps.lengthscale to the
%largest diameter of the mesh along the x, y, or z dimensions.  This uses
%the prismnodes data if it is valid, otherwise the nodes data.
    if mesh.globalProps.prismnodesvalid
        mins = min( mesh.prismnodes, [], 1 );
        maxs = max( mesh.prismnodes, [], 1 );
    else
        mins = min( mesh.nodes, [], 1 );
        maxs = max( mesh.nodes, [], 1 );
    end
    mesh.globalProps.lengthscale = max( maxs-mins );
end
        