function m = stripmesh( m, level )
%m = stripmesh( m, level )
%   Remove from m all data that can be reconstructed from the
%   remainder.  LEVEL can take three values:
%       0: (the default) Only delete information that is perfectly
%          reconstructable.
%       1: In addition, delete certain information that will be zeroed out
%          when the mesh is reinflated.  This information consists of:
%               residual strain
%               ...
%       2: Delete as much information as possible, on the assumption that
%          the resulting data structure will only be used for visualising
%          this state of the mesh, and will not be used for further
%          computation.
%
%   See also: INFLATEMESH.

    m = safermfield( m, ...
            'unitcellnormals', ...
            'cellareas', ...
            ... % 'displacements', ...
            'nodes', ...
            'gradpolgrowth', ...
            'gradpolbend', ...
            'polfrozen', ...
            'effectiveGrowthTensor', ...
            'currentbendangle', ...
            'strainhandles', ...
            'nodecelledges', ...
            'normalhandles', ...
            'cellstiffness', ...
            'edgeends', ...
            'edgecells', ...
            ... % 'celldata', ...
            'plothandles', ...
            'visible', ...
            'decorFEs', ...
            'decorBCs' ...
            );
        % Keep celledges, in order to reconstruct edgecells and edgeends.
    celldata = m.celldata;
    m = safermfield( m, 'celldata' );
    for ci=1:length(celldata)
        m.celldata(ci,1).eps0gauss = celldata(ci).eps0gauss;
    end
    if false && isfield( m, 'celldata' )
        m.celldata = safermfield( m.celldata, ...
            'gnGlobal', ...
            'residualStrain', ...
            'actualGrowthTensor', ...
            'residualStress', ...
            'Glocal', ...
            'Gglobal', ...
            'fixed' );
    end
    if false && isfield( m, 'celldata' )
        m.celldata = safermfield( m.celldata, ...
            'cellThermExpGlobalTensor', ...
            'eps0gauss' );
            % 'displacementStrain' );
    end
    if false && isfield( m, 'cellFrames' )
        m = rmfield( m, 'cellFrames' );
    end
    if hasSecondLayer( m )
        m.secondlayer = safermfield( m.secondlayer, ...
            'cell3dcoords', ...
            'edges', ...
            'cellarea' );
        m.secondlayer.cells = rmfield( m.secondlayer.cells, 'edges' );
    end
    if isfield( m, 'morphogenclamp' ) && all( m.morphogenclamp(:) == 0 )
        m = rmfield( m, 'morphogenclamp' );
    end
    if isfield( m, 'mgen_production' ) && all( m.mgen_production(:) == 0 )
        m = rmfield( m, 'mgen_production' );
    end
    if isfield( m, 'fixedDFmap' ) && all( m.fixedDFmap(:) == 0 )
        m = rmfield( m, 'fixedDFmap' );
    end
    if isfield( m, 'mgen_production' ) && all( m.mgen_production(:) == 0 )
        m = rmfield( m, 'mgen_production' );
    end
    if isfield( m, 'seams' ) && ~any( m.seams(:) )
        m = rmfield( m, 'seams' );
    end
    if ~any( m.cellbulkmodulus ~= m.cellbulkmodulus(1) )
        m.cellbulkmodulus = m.cellbulkmodulus(1);
    end
    if ~any( m.cellpoisson ~= m.cellpoisson(1) )
        m.cellpoisson = m.cellpoisson(1);
    end
end
