function ig = treeimage( history, minheight, minwidth )
    global graphelements;
    if length(graphelements)==0
        load graphelements graphelements;
    end
    if nargin < 3
        minheight = 0;
        if nargin < 2
            minwidth = 0;
        end
    end
    history.findCoords();
    g = history.makeGrid();
    g(history.row+1,history.col+1,6) = 1;
    sg = size(g);
    blobwidth = 10;
    linewidth = 20;
    cellwidth = blobwidth + linewidth;
    cellheight = 20;
    topmargin = 5;
    bottommargin = 5;
    borders = struct( 'left', 5, 'right', 5, 'top', 5, 'bottom', 5 );
    imageheight = ...
        sg(1)*cellheight - topmargin - bottommargin + borders.top + borders.bottom;
    if imageheight < minheight
        borders.bottom = borders.bottom + minheight - imageheight;
        imageheight = minheight;
    end
    imagewidth = ...
        sg(2)*cellwidth - linewidth + borders.left + borders.right;
    if imagewidth < minwidth
        borders.right = borders.right + minwidth - imagewidth;
        imagewidth = minwidth;
    end
    ig = uint8( ones( [ imageheight, imagewidth, 3 ] ) * 255 );
    lindex = [ 0, 0, 5, 4, 0, 2, 1, 3 ];
    lindex2 = [ 0, 0, 0, 0, 0, 2, 1, 3 ];
    numblobs = 2;
    for row=1:sg(1)
        for col=1:sg(2)
            gc = reshape( g(row,col,:), 1, 6 );
            arms = gc(2)*4 + gc(3)*2 + gc(4)*1 + 1;
            if gc(6), blob = 2;
            elseif gc(1), blob = 1;
            else blob = 0;
            end
            line = lindex(arms);
            if (arms ~= 1) && (line==0)
                fprintf( 1, 'Arms not found in line map.\n' );
                gc
                arms
                blob
                line
            end
            irhi = row*cellheight - topmargin + borders.top;
            if row==1
                irlo = 1 + borders.top;
            else
                irlo = irhi - cellheight + 1;
            end
            ichi = col*cellwidth + borders.left;
            iclo = ichi - cellwidth + 1;
            iclinelo = iclo + blobwidth;
            icblobhi = iclinelo - 1;
            if row==1
                crlo = topmargin+1;
            else
                crlo = 1;
            end
            crhi = cellheight;
            if row==sg(1)
                crhi = crhi - bottommargin;
                irhi = irhi - bottommargin;
            end
            if blob ~= 0
                cblobhi = blob*blobwidth;
                cbloblo = cblobhi - blobwidth + 1;
                ig( irlo:irhi, iclo:icblobhi, 1:3 ) = ...
                    graphelements( crlo:crhi, cbloblo:cblobhi, [3 1 2] );
            end
            if line ~= 0
                clinehi = numblobs*blobwidth + line*linewidth;
                clinelo = clinehi - linewidth + 1;
                ig( irlo:irhi, iclinelo:ichi, 1:3 ) = ...
                    graphelements( crlo:crhi, clinelo:clinehi, [3 1 2] );
            end
        end
    end
    ig = uint8(ig);
end

