function [ m, didsplit ] = trysplit( m )
%[ m, didsplit ] = trysplit( m )    Split all edges which are
%longer than the threshold for splitting.  Split them in descending order
%of length.  Also split cells bordering an edge where the angle has changed
%by too much.

    if (m.globalProps.thresholdsq==0) ...
            && (m.globalProps.thresholdmgen==0) ...
            && (m.globalProps.bendsplit==0)
        return;
    end
    
    if m.globalProps.maxFEcells > 0
        numcells = size(m.tricellvxs,1);
        maxsplits = floor( (m.globalProps.maxFEcells - numcells)/2 );
        if maxsplits <= 0
            return;
        end
    else
        maxsplits = size(m.edgeends,1);
    end
    
    % Find edges that have bent too much.
    if m.globalProps.allowSplitBentFEM ...
            && (~m.globalProps.alwaysFlat) ...
            && (m.globalProps.bendsplit > 0)
        m.initialbendangle = reshape( m.initialbendangle, [], 1 );
        edgebending = abs( m.currentbendangle - m.initialbendangle );
        bentedgemap = ...
            (edgebending > m.globalProps.bendsplit) ...
            & (m.edgecells(:,2) ~= 0);
        edgebending = edgebending(bentedgemap);
        bentedges = reshape( m.celledges( m.edgecells( bentedgemap, : ), : ), [], 1 );
        if ~isempty(bentedges)
            fprintf( 1, 'Bent edges:' );
            fprintf( 1, ' %d', bentedges );
            fprintf( 1, '\n' );
        end
    else
        bentedges = [];
    end
    
    % Find edges that are too long.
    if m.globalProps.allowSplitLongFEM
        lengthsqs = edgelengthsqs(m);
        if m.globalProps.thresholdsq > 0
            splitthreshold = currentEdgeThreshold( m );
            splitmargin = sqrt(max(m.globalProps.splitmargin, 1));
            if any( lengthsqs > splitthreshold*splitmargin )
                longedges = find( lengthsqs > splitthreshold/splitmargin );
            else
                longedges = [];
            end
        end
        if ~isempty(longedges)
            fprintf( 1, 'Long edges:' );
            fprintf( 1, ' %d', longedges );
            fprintf( 1, '\n' );
        end
    else
        longedges = [];
    end
    
    % Find edges with too great a variation in morphogen. (NOT USED.)
    if false && (m.globalProps.thresholdmgen > 0)
        mins = min( m.morphogens, [], 1 );
        maxs = max( m.morphogens, [], 1 );
        ranges = maxs-mins;
        whichmgens = ranges > 0;
        ranges = ranges(whichmgens);
        if any(whichmgens)
            numedges = size( m.edgeends, 1 );
            x = abs(m.morphogens( m.edgeends(:,1), whichmgens ) ...
                     - m.morphogens( m.edgeends(:,2), whichmgens ));
            mgenedgemap = [];
            for i=1:numedges
                x(i,:) = x(i,:) ./ ranges;
                mgenedgemap(i) = any( x(i,:) > m.globalProps.thresholdmgen );
            end
            mgenedges = reshape( find(mgenedgemap), [], 1 );
        end
        if ~isempty(mgenedges)
            fprintf( 1, 'Mgen edges:' );
            fprintf( 1, ' %d', mgenedges );
            fprintf( 1, '\n' );
        end
    else
        mgenedges = [];
    end
    
    edgestosplit = unique( [ bentedges; longedges; mgenedges ] );
  % [ sortedlengths, perm ] = sort( lengthsqs(edgestosplit), 1, 'descend' );
  % edgestosplit(perm) = edgestosplit;
    if maxsplits < length(edgestosplit)
        p = randperm( length(edgestosplit) );
        edgestosplit = edgestosplit(p);
        edgestosplit = edgestosplit(1:maxsplits);
    end
  % edgestosplit
    if ~isempty(edgestosplit)
        m = splitalledges( m, edgestosplit );
    end
    if nargout >= 2
        didsplit = length(longedges) > 0;
    end
end
