function bc = baryToEdge( bc )
%bc = baryToEdge( bc )
%   Move the barycentric coordinate to the nearest edge, by replacing the
%   component with minimum absolute value by zero and renormalising.

    for i=1:size(bc,1)
        [v,bci] = min(abs(bc));
        bc(i,bci) = 0;
        bc(i,:) = bc(i,:)/sum(bc(i,:));
    end
end
