function crosses3( centres, majors, minors, needCross )
    if any(needCross)
        crosscentres = centres(needCross,:);
        crossmajors = majors(needCross,:);
        crossminors = minors(needCross,:);
        quiver3( ...
            [crosscentres(:,1),crosscentres(:,1)], ...
            [crosscentres(:,2),crosscentres(:,2)], ...
            [crosscentres(:,3),crosscentres(:,3)], ...
            [crossmajors(:,1),-crossmajors(:,1)],  ...
            [crossmajors(:,2),-crossmajors(:,2)],  ...
            [crossmajors(:,3),-crossmajors(:,3)],  ...
            0, ...
            '.-', 'Color', [0.1 0.1 0.5], 'LineWidth', 2 );
        quiver3( ...
            [crosscentres(:,1),crosscentres(:,1)], ...
            [crosscentres(:,2),crosscentres(:,2)], ...
            [crosscentres(:,3),crosscentres(:,3)], ...
            [crossminors(:,1),-crossminors(:,1)],  ...
            [crossminors(:,2),-crossminors(:,2)],  ...
            [crossminors(:,3),-crossminors(:,3)],  ...
            0, ...
            '.-', 'Color', [0.1 0.1 0.5], 'LineWidth', 1 );
    end
    if any(~needCross)
        circlecentres = centres(~needCross,:);
        circlemajors = majors(~needCross,:);
        circleminors = minors(~needCross,:);
        plot3circle( circlecentres, circlemajors, circleminors, 12, ...
            '-', 'Color', [0.1 0.1 0.5], 'LineWidth', 2 );
    end
end
