function [v1,v2] = makeframe( v )
%[v1,v2] = makeframe( v )
%  V is a unit vector.  Chose unit vectors V1 and V2 such that [V V1 V2] is
%  a right-handed coordinate system.
%  If V is a nonzero non-unit unit vector, the resulting vectors will be
%  mutually orthogonal, but may be of arbitrary non-zero lengths.
%  If V is zero, V1 and V2 will be zero.

    if any(v)
        v1 = findperp( v );
        v1 = v1/norm(v1);
        v2 = cross(v,v1);
    else
        v1 = zeros(size(v));
        v2 = v1;
    end
end
