function [vi1a,vi1b,v1,vi2a,vi2b,v2] = splitPoly( direction, splitpoint, vxs )
%[vi1a,vi1b,v1,vi2a,vi2b,v2] = splitPoly( direction, splitpoint, vxs )
%   vxs contains the vertexes of a polygon as an N*3 matrix.
%   direction is a direction and splitpoint a point.
%   This routine finds where the plane perpendicular to direction through
%   splitpoint intersects the polygon.

    numvxs = size( vxs, 1 );
    sides = whichSide( direction, splitpoint, vxs );
    sides1 = [ sides(2:end); sides(1) ];
    boundary = find( sides ~= sides1 );
    if length(boundary) < 2
        vi1a = 0;
        vi1b = 0;
        v1 = 0;
        vi2a = 0;
        vi2b = 0;
        v2 = 0;
        return;
    end
    vi1a = boundary(1);
    vi2a = boundary(2);
    vi1b = mod(vi1a,numvxs) + 1;
    vi2b = mod(vi2a,numvxs) + 1;
    v1 = lineplaneIntersection( vxs(vi1a,:), vxs(vi1b,:), direction, splitpoint );
    v2 = lineplaneIntersection( vxs(vi2a,:), vxs(vi2b,:), direction, splitpoint );
end
