function r = randInEllipse( n, a, b )
% Uniform distribution on an ellipse of specified semi-axes A and B,
% centred on the origin.
  angle(1:n) = 2.0 * pi * rand(1,n);
  radius(1:n) = sqrt ( rand(1,n) );

  r(1,1:n) = a * radius(1:n) .* cos ( angle(1:n) );
  r(2,1:n) = b * radius(1:n) .* sin ( angle(1:n) );
end
