function [i,ok] = askForInt( title, prompt, dflt )
%i = askForInt( title, prompt, initval )
%   Put up a modal dialog asking the user to enter an integer.
%   The dialog will have the specified title.
%   The PROMPT string will be displayed as static text above the text-entry box.
%   INITVAL is the initial contents of the text-entry box.
%   The result will be [] if the user cancelled the dialog (by clicking the
%   "Cancel" button, clicking the close box, or hitting escape).
%   Otherwise, it will be the final contents of the text-entry box,
%   interpreted as an integer.  If it is invalid, the dialog will be re-opened.

    if nargin < 1
        title = '';
    end
    if nargin < 2
        prompt = '';
    end
    haveDflt = nargin >= 3;
    if haveDflt
        i = dflt;
        dfltString = sprintf( '%d', dflt );
    else
        i = [];
        dfltString = '';
    end
    ok = false;
    while true
        s = askForStringDlg( 'title', title, 'prompt', prompt, 'initialvalue', dfltString );
        if isempty(s)
            return;
        end
        result = str2double( s.editableText );
        if isnan(result), continue; end
        if result == floor(result)
            i = result;
            ok = true;
            return;
        end
    end
end




