function showHandleInfo( h, level, name )
    if isempty(h)
        return;
    end
    if nargin < 2
        level = 0;
    end
    if nargin < 3
        name = '-';
    end
    if nargin==3
        if h==int32(h)
            return;
        end
    end
    if length(h)==1
        if ishandle(h)
            tag = get(h,'Tag');
            if isempty(tag), tag = '-'; end
            fprintf( 1, '%*s%d    %s    %s    %s\n', level, '', h, name, get(h,'Type'), tag );
            f = get(h);
            fn = fieldnames(f);
            for i=1:length(fn)
                if ~strcmp( fn{i}, 'Parent' )
                    showHandleInfo( f.(fn{i}), level+2, fn{i} );
                end
            end
            if false
                try
                    c = get(h,'Children');
                    showHandleInfo( c, level+2 );
                catch
                end
            end
        end
    elseif all(ishandle(h(:))) && all(h ~= int32(h))
        for i=1:length(h)
            showHandleInfo( h(i), level+1, name );
        end
    end
end
