function rgb = namedColor( cname )
    rgb = zeros( length(cname), 3 );
    for i=1:length(cname)
        switch cname(i)
            case 'k'
                rgb(i,:) = [0 0 0];
            case 'r'
                rgb(i,:) = [1 0 0];
            case 'g'
                rgb(i,:) = [0 1 0];
            case 'b'
                rgb(i,:) = [0 0 1];
            case 'c'
                rgb(i,:) = [0 1 1];
            case 'm'
                rgb(i,:) = [1 0 1];
            case 'y'
                rgb(i,:) = [1 1 0];
            case 'o'
                rgb(i,:) = [1 0.5 0];
            case 'w'
                rgb(i,:) = [1 1 1];
            otherwise
                rgb(i,:) = [0.5 0.5 0.5];
        end
    end
end
