function [m,ok] = attemptInteractionFunction( m, h )
    haveHandles = nargin >= 2;
    m.globalProps.interactionValid = true;
    ok = true;
    if m.globalProps.allowInteraction && isa(m.globalProps.mgen_interaction,'function_handle')
        m.saved = 0;
        if m.rewriteIFneeded
            [m,ok] = rewriteInteractionSkeleton( m, '', '', mfilename() );
        end
        if ~ok
            % Nothing.  Carry on anyway.
        end
        fprintf( 1, 'Calling interaction function.\n' );
        try
            m = m.globalProps.mgen_interaction( m );
            m.globalProps.allowsave = 0;
        catch
            fprintf( 1, '%s: Interaction function raised an exception:\n', mfilename() );
            simpleExceptionMessage();
            fprintf( 1, 'Interaction disabled.  Simulation terminated.\n' );
            m.globalProps.interactionValid = false;
            m.stop = true;
            if haveHandles
                indicateInteractionValidity( h, false );
            end
            ok = false;
        end
    elseif isa(m.globalProps.mgen_interaction,'function_handle')
        fprintf( 1, 'Interaction function disabled.\n' );
    else
        fprintf( 1, 'No interaction function to call.\n' );
    end
end
