function cc = cellcentres( m, cells, side )
%cc = cellcentres( m, cells, side )
%   Find the centres of all the finite elements, on either the A side, the
%   B side, or the midplane.  side==-1 is the A side, 0 is the midplane,
%   and 1 is the B side.  If side is omitted, it is determined from the
%   plotting options.

    if (nargin < 2) || isempty(cells)
        cells = 1:size(m.tricellvxs,1);
    end

    if nargin < 3
        if ~m.plotdefaults.thick
            side = 0;
        elseif m.plotdefaults.decorateAside
            side = -1;
        else
            side = 1;
        end
    end

    if side==0
        rcellvxs = reshape( m.nodes( m.tricellvxs(cells,:)', : ), 3, [], 3 );
    elseif side == -1
        rcellvxs = reshape( m.prismnodes( -1+2*m.tricellvxs(cells,:)', : ), 3, [], 3 );
    else
        rcellvxs = reshape( m.prismnodes( 2*m.tricellvxs(cells,:)', : ), 3, [], 3 );
    end
    cc = reshape( sum( rcellvxs, 1 ), [], 3 )/3;
end
