function m = leaf_alwaysflat( m, flat )
%m = leaf_alwaysflat( m, flat )
%   If FLAT is 1, force the mesh to never bend out of the XY plane.  The
%   mesh will be flattened if it is not already flat, by setting the Z
%   coordinate of every node to zero.
%   If FLAT is 0, allow the mesh to bend out of the XY plane.  If the mesh
%   happens to be flat, it will not actually bend unless it is perturbed
%   out of the XY plane, e.g. by adding a random Z displacement with the
%   leaf_perturbz command.
%
%   A flat mesh is still allowed to vary in thickness.
%
%   Example:
%       m = leaf_alwaysflat( m, 1 );
%
%   Equivalent GUI operation: clicking the "Always flat" checkbox on the
%   "Mesh editor" panel.
%
%   Topics: Mesh editing, Simulation.

    if isempty(m), return; end
    m.globalProps.alwaysFlat = flat ~= 0;
    if m.globalProps.alwaysFlat
        m = setzeroz( m );
    end
    saveStaticPart( m );
end
