function m = leaf_mgen_zero( m, varargin )
%m = leaf_mgen_zero( m, morphogen )
%   Set the value of a specified morphogen to zero everywhere.
%   Arguments:
%   1: The name or index of a morphogen.
%   Examples:
%       m = leaf_mgen_zero( m, 'growth' );
%   See also: LEAF_MGEN_CONST.
%
%   Equivalent GUI operation: clicking the "Set zero" button in the
%   "Morphogens" panel.
%
%   Topics: Morphogens.

    if isempty(m), return; end
    [ok1, morphogen, args] = getTypedArg( mfilename(), {'numeric','char'}, varargin );
    if ~ok1, return; end
    if ~isempty(args)
        fprintf( 1, '%s: %d extra arguments ignored.\n', mfilename(), length(args) );
    end
    
    g = FindMorphogenIndex( m, morphogen, mfilename() );
    if ~isempty(g)
        m = zerogrowth( m, g );
    end
end
