function definePropertyLists()
%definePropertyLists()
%   This defines some tables of mesh propeties, mainly gGlobalProps (the
%   default value of m.globalProps), gGlobalDynamicProps (the default value
%   of m.globalDynamicProps), and gDefaultPlotOptions (the default value of
%   m.plotdefaults).  Documentation is interspersed with the definitions
%   which can be automatically extracted and used to populate a Help menu.

    global gGlobalProps gGlobalDynamicProps gDefaultPlotOptions
    global gOurViewParams gMatlabViewParams
    global gOurViewParamNames gMatlabViewParamNames
    global gGAUSS_INFO;

    gGAUSS_INFO = computeGaussInfo();

    secondlayercolors = [[0.1,1,0.1];[1,0.1,0.1]];
    secondlayercolorvariation = 0.05;

    gGlobalProps = struct( ... % ITEM leaf_setproperties
        'trinodesvalid', false, ... % DYNAMIC, UNSAVED
        'prismnodesvalid', false, ... % DYNAMIC, UNSAVED
        'thicknessRelative', 0.5, ...
        'thicknessArea', 0, ...
        'thicknessMode', 'physical', ...
        'activeGrowth', 1, ...
        'displayedGrowth', 1, ...
        'displayedMulti', [], ...
        'allowNegativeGrowth', true, ...
        ... % If true, the growth morphogens KAPAR, KAPER, KBPAR, and KBPER
        ... % can be negative.  If false, any negative values arising in the
        ... % computation are replaced by zero.
        'usePrevDispAsEstimate', true, ...
        ... % If true, the computation of elastic deformation will use the
        ... % displacements computed on the previous timestep as the initial
        ... % estimate for the current timestep.  If false, the initial estimate
        ... % will be zero.
        'perturbInitGrowthEstimate', 0.00001, ...
        ... % This defines the amount of random perturbation added to the initial
        ... % estimate for the computation of elastic deformation, as an absolute amount.
        'perturbRelGrowthEstimate', 0.01, ...
        ... % This defines the amount of random perturbation added to the initial
        ... % estimate for the computation of elastic deformation, as a relative amount.
        'perturbDiffusionEstimate', 0.0001, ...
        ... % This defines the amount of random perturbation added to the initial
        ... % estimate for the computation of diffusion.
        'resetRand', false, ...
        ... % If true, the random number generator will be reset to a fixed initial
        ... % state before each use made of it.  This allows exact reproducibility
        ... % of a simulation.  If false, it is never reset.
        'mingradient', 0, ...
        'relativepolgrad', false, ...
        'usefrozengradient', true, ...
        'userpolarisation', false, ...
        'thresholdsq', 0, ...
        'splitmargin', 1.4, ...
        ... % When splitting of long edges is enabled, an edge will be bisected
        ... % if its length is this amount times the threshold.  The default
        ... % value is approximately sqrt(2), so that after splitting the two new
        ... % edges are below the threshold by the same ratio.
        'splitmorphogen', '', ...
        ... % The value of this is the name of a morphogen to be used to influence
        ... % edge-splitting.  Every edge where this morphogen exceeds a specified
        ... % theshold at both ends will be split.  See also 'thresholdmgen'.
        'thresholdmgen', 0.5, ...
        ... % This is the threshold value for morphogen-specified edge-splitting.
        ... % See also 'splitmorphogen'.
        'bulkmodulus', 1, ...
        ... % IGNORE
        'unitbulkmodulus', true, ...
        ... % IGNORE
        'poissonsRatio', 0.3, ...
        ... % This sets Poisson's ratio for the material, a constant value everywhere.
        'starttime', 0, ...
        ... % This defines the time at the start of the simulation.
        'timestep', 0.01, ...
        ... % This is the time step of the simulation.  It should be chosen small enough
        ... % that in a single time step, no part of the mesh grows by more than 10% in
        ... % any direction, and rotates by no more than 10 degrees.  For more accurate
        ... % runs, these criteriashould be reduced to 5% and 5 degrees.
        'timeunitname', '', ...
        ... % This is the name of the unit of time, and should be given in the singular.
        'distunitname', 'mm', ...
        ... % This is the name of the unit of length.
        'scalebarvalue', 0, ...
        'validateMesh', true, ...
        ... % This is for debugging only.  If true, a large set of validation checks
        ... % is run after each simulation step, to verify the integrity of the data
        ... % structures.
        'rectifyverticals', false, ...
        ... % If true, after each simulation step the pairs of vertexes on opposite
        ... % side of the mesh are moved as necessary to ensure that the line joinging
        ... % them is perpendicular to the mesh.  The midpoint of this line does not move.
        ... % This should be thought of as revising the decomposition of the material
        ... % into finite elements, not as a deformation of the material.
        'allowSplitLongFEM', true, ...
        ... % This boolean flag specifies whether edges exceeeding a certain length
        ... % threshold should be split after each simulation step.
        'longSplitThresholdPower', 0, ...
        'allowSplitBentFEM', false, ...
        'allowSplitBio', true, ...
        'allowFlipEdges', false, ...
        'allowElideEdges', true, ...
        'mincellangle', 0.2, ...
        'alwaysFlat', false, ...
        'flattenforceconvex', true, ...
        'flatten', false, ... % IGNORE.  Obsolete but harmless
        'flattenratio', 1, ... % IGNORE.  Obsolete but harmless
        'useGrowthTensors', false, ...
        'plasticGrowth', false, ...
        ... % If true, the material is modelled as a fluid flowing with Reynolds
        ... % number equal to zero, which is the limiting behaviour as Poisson's
        ... % ratio tends to 0.5.  The default is to model it as an elastic solid.
        'totalinternalrotation', 0, ... % IGNORE
        'stepinternalrotation', 2, ... % IGNORE radians
        'showinternalrotation', false, ... % IGNORE
        'performinternalrotation', false, ... % IGNORE
        'internallyrotated', false, ... % IGNORE
        'maxFEcells', int32(0), ...
        ... % This specifies the maximum number of finite elements the mesh is
        ... % allowed to contain.  When it reaches this number, no more edge-splitting
        ... % will be done.  A value of zero means the number is unlimited.
        'inittotalcells', int32(0), ...
        'bioApresplitproc', '', ...
        ... % This should be the name of a function which will be called immediately
        ... % before determining whether any biological cells should be split.  This
        ... % function can be used to override the default cell-splitting method.  The
        ... % method of writing this function is rather complex and not documented here.
        'bioApostsplitproc', '', ...
        ... % This should be the name of a function which will be called immediately
        ... % after having split some biological cells.  This
        ... % function can be used to override the default cell-splitting method.  The
        ... % method of writing this function is rather complex and not documented here.
        'maxBioAcells', int32(0), ...
        ... % This specifies the maximum number of biological cells the mesh is
        ... % allowed to contain.  When it reaches this number, no more cell-splitting
        ... % will be done.  A value of zero means the number is unlimited.
        'colors', secondlayercolors, ...
        'colorvariation', secondlayercolorvariation, ...
        'colorparams', makesecondlayercolorparams( secondlayercolors, secondlayercolorvariation ), ...
        'biocolormode', 'auto', ...
        'freezing', 0, ...
        'canceldrift', false, ...
        ... % If true, after each simulation step, the mesh is repositioned if necessary
        ... % to force its centre (defined as the average of all of its vertexes) to
        ... % remain stationary.
        'mgen_interaction', '', ...
        ... % READ-ONLY.  This is a handle to the interaction function, and should not be
        ... % modified by the user.
        'mgen_interactionName', '', ...
        ... % READ-ONLY.  This is the name of the interaction function, and should not be
        ... % modified by the user.
        'allowInteraction', true, ...
        ... % This specifies whether the interaction function should be called during each
        ... % simulation step.
        'interactionValid', true, ... % UNSAVED
        ... % READ-ONLY.  If an error is detected in the interaction function, this
        ... % flag will be set to false.  It reverts to true of GFtbox detects that
        ... % the user has edited it, or when the Reset button in the GUI is clicked.
        'gaussInfo', gGAUSS_INFO, ... % IGNORE
        'stitchDFs', [], ...
        'D', zeros(6,6), ... % IGNORE
        'C', zeros(6,6), ... % IGNORE
        'G', zeros(6,1), ... % IGNORE
        'solver', 'cgs', ...
        ... % This specifies which solver to user when computing elastic deformation.
        'solverprecision', 'double', ...
        'solvertolerance', 0.001, ...
        'solvertolerancemethod', 'norm', ...
        'diffusiontolerance', 0.00001, ...
        'allowsparse', true, ...
        'maxIters', int32(0), ...
        'maxsolvetime', 1000, ...
        'cgiters', int32(0), ...
        'simsteps', int32(0), ...
        'stepsperrender', int32(0), ...
        'growthEnabled', true, ...
        ... % This specifies whether elastic growth is to be computed during a
        ... % simulation step.
        'diffusionEnabled', true, ...
        ... % This specifies whether diffusion is to be computed during a
        ... % simulation step.
        'flashmovie', false, ...
        ... % This specifies whether all movies should be automatically
        ... % converted to Flash format on completion.
        'makemovie', false, ...
        ... % This specifies whether a frame is to be saved to a movie file
        ... % after each simulation step.
        'moviefile', '', ...
        ... % The name of the current movie file (empty when a movie is not being recorded).
        'codec', 'None', ...
        ... % The codec to be uesd when recording a movie file.
        'autonamemovie', true, ...
        ... % If true, when a movie is started, a name will be automatically
        ... % generated for the movie file.  If false, the user will be presented
        ... % with a file dialog to choose the name.
        'overwritemovie', false, ...
        ... % When this is true, no check will be made to see if an automatically
        ... % generated movie file name already exists.  If false, the name will be
        ... % modified by appending a unique number in order to prevent any existing
        ... % fie from being overwritten.
        'framesize', [], ... % IGNORE UNSAVED
        'mov', [], ... % IGNORE UNSAVED
        'boingNeeded', false, ... % IGNORE 
        'initialArea', 0, ...
        'bendunitlength', 0, ...
        'targetRelArea', 1, ... % UNSAVED
        'defaultinterp', 'min', ...
        'readonly', false, ...
        'projectdir', '', ...
        'modelname', '', ...
        'allowsave', true, ... % IGNORE UNSAVED
        'addedToPath', false, ... % IGNORE UNSAVED
        'bendsplit', 0.3, ...
        'usepolfreezebc', false, ...
        'dorsaltop', true, ...
        'defaultazimuth', -45, ...
        'defaultelevation', 33.75, ...
        'defaultroll', 0, ...
        'defaultViewParams', gMatlabViewParams, ...
        'comment', '', ...
        'legendTemplate', '%T: %q\n%m', ...
        ... % This is the format string used to define the legend appearing
        ... % at the top of the picture area.
        'bioAsplitcells', true, ...
        ... % Allow splitting of biological cells.
        'bioApullin', 4/28, ...
        'bioAfakepull', 0.7/(2*sqrt(3)), ...
        'interactive', false, ...
        ... % READ-ONLY.  Says whether GFtbox is running interactively.  Obsolete?
        'coderevision', int32(0), ...
        ... % READ-ONLY.  The current revision number of GFtbox.
        'coderevisiondate', '', ...
        ... % READ-ONLY.  The current revision date of GFtbox.
        'modelrevision', int32(0), ...
        ... % READ-ONLY.  The latest revision of GFtbox that this model was
        ... % operated on with.  Backward compatibility is retained: old models
        ... % should always be loadable into new versions of GFtbox.  The reverse
        ... % is not necessarily the case.  This field will tell you if the model
        ... % has been edited with a newer version of GFtbox that you are currently
        ... % running.
        'modelrevisiondate', '', ...
        ... % READ-ONLY.  The date of the latest revision of GFtbox that this model was
        ... % operated on with.  See also 'modelrevision'.
        'savedrunname', '', ... % IGNORE
        'savedrundesc', '' ... % IGNORE
    );
    gGlobalProps.vxgrad(:,:,1) = gradN( [ 0; 0; 1 ] );
    gGlobalProps.vxgrad(:,:,2) = gradN( [ 1; 0; 1 ] );
    gGlobalProps.vxgrad(:,:,3) = gradN( [ 0; 1; 1 ] );
    gGlobalProps.vxgrad(:,:,4) = gradN( [ 0; 0; -1 ] );
    gGlobalProps.vxgrad(:,:,5) = gradN( [ 1; 0; -1 ] );
    gGlobalProps.vxgrad(:,:,6) = gradN( [ 0; 1; -1 ] );

    gGlobalDynamicProps = struct( ... % ITEM leaf_setproperties
        'currenttime', 0.0, ... % DYNAMIC
        'currentIter', 0, ... % DYNAMIC
        'laststagesuffix', '', ... % DYNAMIC, UNSAVED
        'currentArea', 0, ... % DYNAMIC
        'previousArea', 0, ... % DYNAMIC
        'thicknessAbsolute', 0, ... % DYNAMIC?
        'cellscale', 0, ... % DYNAMIC
        'locatenode', 0, ... % DYNAMIC
        'locateDFs', [], ... % DYNAMIC
        'staticreadonly', false, ... % DYNAMIC
        'commandok', true, ... % DYNAMIC
        'doinit', true ... % DYNAMIC
    );

    gOurViewParams =  struct( ...
        'azimuth', -45, ...
        'elevation', 33.75, ...
        'roll', 0, ...
        'fov', 10, ...
        'pan', [0 0], ...
        'targetdistance', 0, ...
        'camdistance', 4*sqrt(3)/(2*tan(5*pi/180)), ...
        'projection', 'orthographic' );
    gMatlabViewParams = cameraParamsFromOurViewParams( gOurViewParams );
    gOurViewParamNames = fieldnames( gOurViewParams );
    gMatlabViewParamNames = fieldnames( gMatlabViewParams );

    gDefaultPlotOptions = struct( ... % ITEM leaf_plotoptions
        'drawtensoraxes', false, ...
        'unitcrosses', true, ...
        ... % 'tensorquantity', 'resultantgrowthrate', ... % New 2009-11-11
        ... % 'tensorproperty', 'total', ...
        'outputquantity', 'resultantgrowthrate', ...
        'outputaxes', 'total', ...
        'morphogen', 1, ...
        'rawstuff', [], ...
        'drawleaf', 1, ...
        'drawedges', 1, ...
        'drawseams', 1, ...
        'fillleaf', 1, ...
        'drawgradients', 0, ...
        'unitgradients', 0, ...
        'multibrighten', 0.1, ...
        ... % 'monochrome', true, ...
        'monocolors', [[0 0 1];[1 0 0]], ...
        'canvascolor', [1 1 1], ...
        'cmap', [], ...
        'crange', [], ...
        'zerowhite', 0, ...
        'cmaptype', 'monochrome', ...
        'sparsedistance', 0, ...
        'staticdecor', true, ...
        'axisRange', [], ...
        'axisVisible', 1, ...
        'alpha', 0.8, ...
        'ambientstrength', 0.8, ...
        'azimuth', -45, ...
        'elevation', 33.75, ...
        'roll', 0, ...
        'ourViewParams', gOurViewParams, ...
        'matlabViewParams', gMatlabViewParams, ...
        'autozoom', false, ...
        'autocentre', false, ...
        'autoScale', 1, ...
        'autoColorRange', 1, ...
        'drawsecondlayer', 0, ...
        'cellsonbothsides', true, ...
        'layeroffset', 0.2, ...
        'FEthicklinesize', 2, ...
        'FEthinlinesize', 1, ...
        'FElinecolor', [0 0 0], ...
        'seamlinesize', 5, ...
        'seamlinecolor', [1 0 0], ...
        'bioAlinesize', 1, ...
        'bioAlinecolor', [0.2 0.2 0.2], ...
        'bioAnewlinecolor', [0.2 0.2 0.2], ...
        'bioApointsize', 3, ...
        'bioApointcolor', [0.2 0.2 0.2], ...
        'bioAnewpointcolor', [0.2 0.2 0.2], ...
        'bioAalpha', 1, ...
        'axescolor', [0 0 0.3], ...
        'decorateAside', false, ...
        'drawnormals', 0, ...
        'drawmutant', 1, ...
        'drawdisplacements', 0, ...
        'drawlegend', 1, ...
        'drawscalebar', 1, ...
        'thick', 1, ...
        'nodenumbering', 0, ...
        'nodenumbercolor', [1 0 0], ...
        'edgenumbering', 0, ...
        'edgenumbercolor', [0 0.4 0.1], ...
        'FEnumbering', 0, ...
        'FEnumbercolor', [0 0 0.4], ...
        'texture', 0, ...
        'bgcolor', [1 1 1], ...
        'emptycolor', [0.7, 0.8, 1], ...
        'clippingAzimuth', 0, ...
        'clippingElevation', 0, ...
        'clippingDistance', -0.01, ...
        'clipbymgen', false, ...
        'clipmgens', [], ...
        'clipmgenthreshold', 0, ...
        'clipmgenabove', true, ...
        'clipmgenall', true, ...
        'doclip', false, ...
        'uicontrols', true, ...
        'light', false, ...
        'lightmode', 'gouraud', ...
        'invisibleplot', false, ...
        'decorscale', 1, ...
        'highlightthickness', 3, ...
        'arrowthickness', 2, ...
        'crossthickness', 1, ...
        'arrowheadsize', 0.5, ...
        'arrowheadratio', 0.3, ...
        'highgradcolor', [0 0 0.3], ...
        'lowgradcolor', [0.5 0 0], ...
        'hiresdpi', 400, ...
        'mgenownsideonly', 'false', ...
        'taper', 'true', ...
        'anisotropythreshold', 0, ...
        'userplotproc', [] );
end
