function m = deleteGeometry( m )
%m = deleteGeometry( m )
%   Delete all geometrical information from m, and everything that
%   depends on it.

    m = safermfield( m, ...
        'nodes', ...
        'prismnodes', ...
        'tricellvxs', ...
        'celledges', ...
        'edgeends', ...
        'edgecells', ...
        'morphogens', ...
        'morphogenclamp', ...
        'gradpolgrowth', ...
        'polfreeze', ...
        'polfreezebc', ...
        'polfrozen', ...
        'anisotropy', ...
        'effectiveGrowthTensor', ...
        'celldata', ...
        'cellareas', ...
        'unitcellnormals', ...
        'cellFrames', ...
        'secondlayer' ...
    );
    m.globalProps.trinodesvalid = false;
    m.globalProps.prismnodesvalid = false;
    m.fixedDFmap = [];
    m.globalProps.boingNeeded = false;
    m.globalDynamicProps.currentArea = 0;
    m.globalDynamicProps.previousArea = 0;
    m.globalProps.initialArea = 0;
    m.globalProps.bendunitlength = 0;
    m.globalDynamicProps.cellscale = 0;
    m.globalProps.targetRelArea = 0;
    m.globalProps = safermfield( m.globalProps, 'thickness' );
end
