function handles = edgeClick( handles, ei, selectionType )
% This should only be called when the simulation is not running.

    switch handles.mesh.interactionMode.clickMode
        case '----'
            % Should forward.
        case 'Seam edges'
            handles.mesh.seams(ei) = ~handles.mesh.seams(ei);
            % Update plot.
            handles.mesh.selection.highlightedEdges = find( handles.mesh.seams );
          % edgeClick_highlightedEdges = handles.mesh.selection.highlightedEdges
            if handles.mesh.seams(ei)
                % draw it
                handles.mesh = plotHighlightedEdges( handles.mesh, ei );
            elseif ei <= length(handles.mesh.plothandles.HLedgehandles)
                eh = handles.mesh.plothandles.HLedgehandles(ei);
                if ishandle(eh)
                    delete(eh);
                else
                    fprintf( 1, 'Edge %d removed from seam had an invalid handle %f.\n', ei, eh );
                end
            else
                fprintf( 1, 'Edge %d removed from seam had no recorded handle, num handles %d.\n', ...
                    ei, length(handles.mesh.plothandles.HLedgehandles) );
            end
            drawnow;
        case 'Subdivide edge'
            % Not implemented yet.
        case 'Elide edge'
            handles.mesh = elideEdge( handles.mesh, ei );
            handles = GUIPlotMesh( handles );
        case 'Elide cell pair'
            handles.mesh = elideCells( handles.mesh, ei );
            handles = GUIPlotMesh( handles );
        case 'showvalue'
            if ei > 0
                vis = handles.mesh.edgeends(ei,:);
                pts = handles.mesh.nodes(vis,:);
                hitline = get( handles.picture, 'CurrentPoint' );
                hitvec = hitline(2,:)-hitline(1,:);
                midpt = sum(pts,1)/2;
                d1 = dot( midpt-hitvec(1,:), hitvec );
                d2 = dot( pts(1,:)-hitvec(1,:), hitvec );
                isend1 = (d1 > 0)==(d2 > 0);
                vi = vis( isend1 + 1 );
                mgenIndex = getDisplayedMgenIndex( handles );
                mgenName = handles.mesh.mgenIndexToName{mgenIndex};
                text = sprintf( 'Vx %d: %s = %.3f\n', ...
                    vi, mgenName, handles.mesh.morphogens(vi,mgenIndex) );
                set( handles.siminfoText, 'String', text );
            end
        otherwise
            % Should forward vertexclick or cellclick types.
            complain( 'edgeClick: ''%s'' not implemented.\n', ...
                handles.mesh.interactionMode.clickMode );
    end
end
