function t = getAllStageTimes( stagesmenu )
    t = sort( getAllStageTimes1( stagesmenu ) );
end

function t = getAllStageTimes1( stagesmenu )
    c = get( stagesmenu, 'Children' );
    if isempty(c)
        stagetag = get( stagesmenu, 'Tag' );
        stagestring = stageTagToString( stagetag );
        t = stageStringToReal( stagestring );
    else
        tt = cell( 1, length(c) );
        len = 0;
        for i=1:length(c)
            tt{i} = getAllStageTimes1( c(i) );
            len = len + length(tt{i});
        end
        t = zeros( 1,len );
        start = 0;
        for i=1:length(c)
            n = length(tt{i});
            t( (start+1):(start+n) ) = tt{i};
            start = start + n;
        end
    end
end
