function m = makeCellFrames( m )
%m = makeCellFrames( m )
%   Calculate the preferred frame of reference of every cell.  Column 1 is
%   the polarisation gradient, column 2 the perpendicular in the plane of
%   the cell, and column 3 the normal to the cell.

    numcells = size(m.tricellvxs,1);
    
    if ~isempty( m.growthanglepervertex )
        m.growthangleperFE = perVertexToperFE( m, m.growthanglepervertex );
    end

    if ~isempty( m.growthangleperFE )
        polgrad = rotateVecAboutVec( m.gradpolgrowth, m.unitcellnormals, m.growthangleperFE );
    else
        polgrad = m.gradpolgrowth;
    end

    if isempty( m.cellFrames )
        m.cellFrames = zeros( 3, 3, numcells );
    end
    for ci=1:numcells
        m.cellFrames(:,:,ci) = ...
            getCellFrame( m.unitcellnormals(ci,:), polgrad(ci,:) );
    end
end
