function J = makebasis( v1, v2 )
%J = makebasis( v1, v2 )    Set J to an orthonormal matrix whose column
%vectors j1, j2, j3 are given by:
%    j1 is parallel to v1.
%    j2 is in the plane of v1 and v2, and has a positive dot product with
%    v2.
%    [j1 j2 j3] is a right-handed basis.
% v1 and v2 must be linearly independent non-zero three-element row vectors.
% If v2 is not supplied, an arbitrary suitable value will be chosen.

    if nargin < 2
        i = find(v1 ~= 0, 1);
        j = i+1;  if j==4, j = 1; end
        v2 = [0,0,0];
        v2(i) = v1(j);
        v2(j) = -v1(i);
    end

    j1 = v1/norm(v1);
    j2 = v2 - j1*dotproc2(v2,j1);
    j2 = j2/norm(j2);
    j3 = crossproc2( j1, j2 );
    J = [ j1', j2', j3' ];
end