function mouseeditmodeMenu_Callback(hObject, eventdata, handles)
% --- Executes on selection change in mouseeditmodeMenu.
    label = getMenuSelectedLabel( handles.mouseeditmodeMenu );
    fprintf( 1, 'mouseeditmodeMenu_Callback %s\n', label );
    switch label
        case { '----', 'morph----' }
            handles.mesh = establishInteractionMode( handles.mesh, ...
                label );
        case 'Fix nodes'
            set( handles.fixXbox, 'Visible', 'on' );
            set( handles.fixYbox, 'Visible', 'on' );
            set( handles.fixZbox, 'Visible', 'on' );
            set( handles.unfixallButton, 'Visible', 'on' );
            handles.interfacestate.fixedmode.x = get( handles.fixXbox, 'Value' );
            handles.interfacestate.fixedmode.y = get( handles.fixYbox, 'Value' );
            handles.interfacestate.fixedmode.z = get( handles.fixZbox, 'Value' );
            handles.mesh = establishInteractionMode( handles.mesh, ...
                label, ...
                handles.interfacestate.fixedmode );
        case 'Locate node'
            handles.mesh = establishInteractionMode( handles.mesh, ...
                label, ...
                handles.interfacestate.fixedmode );
        case 'Delete element'
            set( handles.fixXbox, 'Visible', 'off' );
            set( handles.fixYbox, 'Visible', 'off' );
            set( handles.fixZbox, 'Visible', 'off' );
            set( handles.unfixallButton, 'Visible', 'off' );
            handles.mesh = establishInteractionMode( handles.mesh, ...
                label );
        case 'Seam edges'
            handles.mesh = establishInteractionMode( handles.mesh, ...
                label );
        case 'Subdivide vertex'
            complain( 'Manual subdivision not implemented yet.\n' );
            handles.mesh = establishInteractionMode( handles.mesh, ...
                label );
        case 'Subdivide edge'
            complain( 'Manual subdivision not implemented yet.\n' );
            handles.mesh = establishInteractionMode( handles.mesh, ...
                label );
        case 'Subdivide element'
            complain( 'Manual subdivision not implemented yet.\n' );
            handles.mesh = establishInteractionMode( handles.mesh, ...
                label );
        case 'Elide edge'
            handles.mesh = establishInteractionMode( handles.mesh, ...
                label );
        case 'Elide cell pair'
            handles.mesh = establishInteractionMode( handles.mesh, ...
                label );
        otherwise
    end
    guidata( hObject, handles );
end
