function runToButton_Callback(hObject, eventdata, handles)
    if isempty( handles.mesh )
        fprintf( 1, 'No mesh.\n' );
        return;
    end

    if get( handles.runFlag, 'Value' )
        % WARNING: Should ask user.
        beep;
        return;
    end
    
    [ runTarget, ok1 ] = ...
        getDoubleFromDialog( handles.areaTargetText, 0 );
    if ok1
        handles.mesh.globalProps.targetRelArea = runTarget;
        handles.mesh.globalProps.targetAbsArea = ...
            handles.mesh.globalProps.targetRelArea ...
            * handles.mesh.globalProps.initialArea;
        setRunning( handles, 1 );
        clearFlag( handles, 'stopButton' );
        oldCursor = get(gcf,'Pointer');
        set(gcf,'Pointer','watch');
        handles.mesh = leaf_iterate( handles.mesh, ...
            0, ...
            'targetarea', handles.mesh.globalProps.targetRelArea, ...
            'plot', 1, ...
            'handles', handles );
        setRunning( handles, 0 );
        guidata(hObject, handles);
        set(gcf,'Pointer',oldCursor);
    end
end
