function secondlayer = deleteCellsInFEs( secondlayer, goodFEmap )
%secondlayer = deleteCellsInFEs( secondlayer, badFEmap )
%   This deletes every second layer cell, any vertexes of which lie in any
%   of the finite elements listed in badFEs.  This is called by deletecell,
%   which deletes finite elements.

    goodVxsmap = goodFEmap(secondlayer.vxFEMcell);
    numcells = length( secondlayer.cells );
    testCell = false( 1, numcells );
    for ci=1:numcells
        testCell(ci) = all( goodVxsmap( secondlayer.cells(ci).vxs ) );
    end
    secondlayer = deleteSecondLayerCells( secondlayer, find(~testCell) );
    return;

    numedges = size( secondlayer.edges, 1 );
    
    goodVxsmap = goodFEmap(secondlayer.vxFEMcell);
    oldToNewVx = zeros(length(secondlayer.vxFEMcell),1);
    oldToNewVx(goodVxsmap) = 1:sum(goodVxsmap);
    secondlayer.vxFEMcell = secondlayer.vxFEMcell( goodVxsmap );

    % vxBaryCoords
    secondlayer.vxBaryCoords = secondlayer.vxBaryCoords( goodVxsmap, : );

    % cell3dcoords
    secondlayer.cell3dcoords = secondlayer.cell3dcoords( goodVxsmap, : );
    
    testCell = false( 1, numcells );
    for ci=1:numcells
        testCell(ci) = all( goodVxsmap( secondlayer.cells(ci).vxs ) );
    end
    [ newToOldCell, oldToNewCell ] = makeRenumbering( testCell );
    
    testEdge = false( 1, numedges );
    for ei=1:numedges
        testEdge(ei) = ...
            testCell( secondlayer.edges( ei, 3 ) ) ...
            || ( (secondlayer.edges( ei, 4 ) ~= 0) ...
                 && testCell( secondlayer.edges( ei, 4 ) ) );
    end
    [ newToOldEdge, oldToNewEdge ] = makeRenumbering( testEdge );
   
    % edges
    secondlayer.edges = secondlayer.edges( testEdge, : );
    numedges = size( secondlayer.edges, 1 );
    secondlayer.edges(:,1:2) = renumberArray( secondlayer.edges( :, 1:2 ), oldToNewVx );
    for ei=1:numedges
        ci1 = secondlayer.edges(ei,3);
        if ci1==0
            fprintf( 1, 'deleteFemToSecondLayer: error, edge %d invalid: ', ei );
            fprintf( 1, ' %d', secondlayer.edges(ei,:) );
            fprintf( '\n' );
        end
        ci2 = secondlayer.edges(ei,4);
        ci1a = oldToNewCell(ci1);
        if ci2 ~= 0
            ci2a = oldToNewCell(ci2);
        else
            ci2a = 0;
        end
        if ci1a==0
            ci1a = ci2a;
            ci2a = 0;
        end
        secondlayer.edges(ei,3:4) = [ ci1a, ci2a ];
    end

    % cells
    secondlayer.cells = secondlayer.cells( testCell );
    % cellcolor
    if ~isempty( secondlayer.cellcolor )
        secondlayer.cellcolor = secondlayer.cellcolor( testCell, : );
    end
    numcells = length( secondlayer.cells );
    % cells().vxs
    % cells().edges
    for ci=1:numcells
        secondlayer.cells(ci).vxs = oldToNewVx( secondlayer.cells(ci).vxs );
        secondlayer.cells(ci).edges = oldToNewEdge( secondlayer.cells(ci).edges );
    end

    ok = checkclonesvalid( secondlayer );
end

