function mesh = setlinearfield( ...
                    mesh, ...
                    maxgf, ...
                    whichGrowth, ...
                    direction, ...
                    add )
%mesh = setlinearfield( mesh, maxgf, whichGrowth, direction, add )    Set a field of
%growth factor with a linear gradient in a given direction.

    if nargin < 4, direction = [1,0,0]; end
    if nargin < 5, add = 0; end
    
    if length(direction)==1
        % direction is an angle with the X axis in radians.
        direction = [ cos(direction), sin(direction), 0 ];
    end

    mesh = makeTRIvalid( mesh );

    newgrowth = zeros( size(mesh.nodes,1), 1 );
    for i=1:size(mesh.nodes,1)
        lincoord = dotproc2( direction, mesh.nodes(i,1:3) );
        newgrowth(i) = lincoord;
    end
    ming = min( newgrowth );
    maxg = max( newgrowth );
    if maxg==ming
        newgrowth = maxgf;
    else
        newgrowth = (newgrowth - ming)*maxgf/(maxg-ming);
    end
    if add
        mesh.morphogens(:,whichGrowth) = newgrowth + mesh.morphogens(:,whichGrowth);
    else
        mesh.morphogens(:,whichGrowth) = newgrowth;
    end
    mesh.saved = 0;
end
