function m = storeCodeRevInfo( m )
    [coderev,codedate] = GFtboxRevision();
    modeldir = getModelDir(m);
    if ~isempty(modeldir)
        [modelrev,modeldate] = svnrevision(modeldir,false);
        if m.globalProps.modelrevision <= modelrev
            m.globalProps.modelrevision = modelrev;
            modeldate = regexprep( modeldate, 'T', ' ' );
            modeldate = regexprep( modeldate, 'Z', '' );
            m.globalProps.modelrevisiondate = modeldate;
        end
    end
    if m.globalProps.coderevision > coderev
        fprintf( 1, [ 'This model was last edited with a more recent version of GFtbox (%d)\n', ...
                      'than the one you are running (%d).\n' ], ...
                 m.globalProps.coderevision, coderev );
    else
        m.globalProps.coderevision = coderev;
        codedate = regexprep( codedate, 'T', ' ' );
        codedate = regexprep( codedate, 'Z', '' );
        m.globalProps.coderevisiondate = codedate;
    end
end
