function [principalAxes,eigs] = bestFitEllipsoid( vxs )
%principalAxes = bestFitEllipsoid( vxs )
%   Find the best-fit ellipsoid containing the vertexes VXS, an N*D array
%   where D is the number of dimensions.  The result is returned as a
%   matrix of column vectors, being the principal axes of the ellipsoid.

    N = size(vxs,1);
    c = sum(vxs,1)/N;
    m = (vxs' * vxs) / N - c'*c;
    [principalAxes,eigs] = eig(m);
end
