function [pts,scaling,oldcentre,newcentre] = fitToBbox( pts, bbox, isotropic )
    if isempty(bbox)
        scaling = [1 1 1];
        oldcentre = [0 0 0];
        newcentre = oldcentre;
        return;
    end
    if nargin < 3
        isotropic = true;
    end
    ptsmin = min(pts,[],1);
    ptsmax = max(pts,[],1);
    bboxcentre = (bbox([1 3 5]) + bbox([2 4 6]))/2;
    ptscentre = (ptsmax + ptsmin)/2;
    bboxsize = bbox([2 4 6]) - bbox([1 3 5]);
    ptssize = ptsmax - ptsmin;
    scaling = bboxsize./ptssize;
    if isotropic
        scaling = repmat( min(scaling), 1, length(scaling) );
    end
    for i=1:size(pts,2)
        pts(:,i) = (pts(:,i) - ptscentre(i))*scaling(i) + bboxcentre(i);
    end
    oldcentre = ptscentre;
    newcentre = bboxcentre;
end

