function [b,v] = lineIntersection( v1, v2, v3, v4 )
%[b,v] = lineIntersection( v1, v2, v3, v4 )
%   Find the intersection of the lines v1 v2 and v3 v4.
%   The vectors must be 2-dimensional column vectors.
%   b is true if the lines intersect, v is the intersection.
%   v is not computed unless asked for.
    i = pinv( [ v1-v2, v4-v3 ] );
    a = i * (v4-v2);
    b = all( (a >= 0) & (a <= 1) );
    if nargout > 1
        if b
            v = a(1)*v1 + (1-a(1))*v2;
        else
            v = [ 0; 0 ];
        end
    end
  % v1 = c(2)*v3 + (1-c(2))*v4
end
