function [x,ok] = askForText( title, rubric )
%[x,ok] = askForText( title, rubric )
%   Present a modal dialog to request some multiline text from the user.
%   TITLE will be used as the title of the figure and RUBRIC is a string
%   that will appear within the figure at the top.
%   x will be returned as a one-dimensional character array containing
%   newline characters to separate the lines.  Trailing spaces before
%   newlines will have been removed.
%   OK will be true if the user clicked the OK button, false if the user
%   cancelled the dialog.  In the latter case X will be empty.

    initvals = struct( 'figure', title, 'rubric', rubric );
    result = performRSSSdialogFromFile( 'askForText.txt', initvals );
    ok = ~isempty(result);
    if ok
        x = result.text;
        if size(x,1) > 1
            x(:,end+1) = char(10);
            x = reshape( x', 1, [] );
            x = regexprep( x, ' +\n', '\n' );
        end
    else
        x = [];
    end
end
