function labelAxes( theaxes, xlabel, ylabel, zlabel )
    if nargin < 1
        theaxes = gca;
        xlabel = 'X';
        ylabel = 'Y';
        zlabel = 'Z';
    elseif ishandle(theaxes)
        if nargin < 4
            zlabel = 'Z';
        end
        if nargin < 3
            ylabel = 'Y';
        end
        if nargin < 2
            xlabel = 'X';
        end
    else
        if nargin == 1
            zlabel = 'Z';
            ylabel = 'Y';
            xlabel = theaxes;
        elseif nargin == 2
            zlabel = 'Z';
            ylabel = xlabel;
            xlabel = theaxes;
        else
            zlabel = ylabel;
            ylabel = xlabel;
            xlabel = theaxes;
        end
        theaxes = gca;
    end
    
    h = get( theaxes, 'Xlabel' );
    set( h, 'String', xlabel );
    h = get( theaxes, 'Ylabel' );
    set( h, 'String', ylabel );
    h = get( theaxes, 'Zlabel' );
    set( h, 'String', zlabel );
end
