function [c,range] = blueRedCmap( range )
    if nargin==0, range = [-1 1]; end
    if range(1) > 0, range(1) = 0; end
    if range(2) < 0, range(2) = 0; end
    if range(1)==range(2)
        c = [1 1 1
             1 1 1];
        return;
    end

    bluepart = [ 1 1 1
                 0.5 1 0.5
                 0 1 1
                 0 0.5 1
                 0 0 1
                 0 0 0.5 ];
    redpart = [ 1 1 1
                1 1 0.5
                1 1 0
                1 0.5 0
                1 0 0
                0.7 0 0 ];
    nsteps = 50;
    bluefrac = range(1)/(range(1)-range(2));
    redfrac = range(2)/(range(2)-range(1));
    nblue = ceil(bluefrac*nsteps);
    nred = ceil(redfrac*nsteps);
    maxfrac = max(bluefrac,redfrac);
    bluefrac = bluefrac/maxfrac;
    redfrac = redfrac/maxfrac;
    if nblue==0
        redmap = makeCmap( redpart, nred+1, redfrac );
        c = redmap;
    elseif nred==0
        bluemap = makeCmap( bluepart, nblue, bluefrac );
        c = bluemap(size(bluemap,1):-1:1,:);
    else
        bluemap = makeCmap( bluepart, nblue, bluefrac );
        redmap = makeCmap( redpart, nred, redfrac );
        c = [ bluemap(size(bluemap,1):-1:1,:);
              redmap(2:size(redmap,1),:) ];
    end
end
