function result = userHomeDirectory()
    if isunix
        gethomevar = '$HOME';
    elseif ispc()
        gethomevar = '%USERPROFILE%';
    else
        result = '';
        return;
    end
    [response,result] = system( ['echo ', gethomevar ] );
    if response==0
       if strcmp( result, gethomevar )
           % Argument not recognised.
           result = '';
       else
           % Got the home directory.  Strip trailing newline.
           result = regexprep( result, '\s+$', '' );
       end
    else
       result = '';
    end
end
