function [h,ok] = attemptNewMeshCommand( h, replace, cmd, varargin )
%m = attemptNewMeshCommand( h, replace cmd, varargin )
%   Assumes the simulation is not running.  Executes the specified command
%   cmd(varargin{:}), which creates a new mesh.  If the GUI specifies that
%   a random perturbation should be made, it does so.  If REPLACE is true,
%   the old mesh is discarded, otherwise as many properties as possible of
%   the old mesh are copied to the new one.
%
%   If successful, it installs the new mesh into h.

    ok = false;
    set(gcf,'Pointer','arrow');
    if replace
        m = scriptcommand( [], cmd, varargin{:} );
    else
        m = scriptcommand( h.mesh, cmd, varargin{:} );
    end
    if isempty( m ), return; end
    flat = get( h.alwaysFlat, 'Value' );
    m.globalProps.alwaysFlat = flat;
    if ~flat
        [perturbzamt,ok1] = getDoubleFromDialog( h.zamount );
        if ok1 && (perturbzamt ~= 0)
            m = scriptcommand( m, 'perturbz', perturbzamt );
        end
    elseif any( m.nodes(:,3) )
        set( h.alwaysFlat, 'Value', 0 );
        m.globalProps.alwaysFlat = false;
    end
    h = installNewMesh( h, m );
    ok = true;
end
