function m = buildMorphogenDict( m )
%m = buildMorphogenDist( m )
%   Build a dictionary mapping morphogen names to indexes and vice versa.
%   Make sure the standard morphogens are included.

    setGlobals();
    global gOLD_MorphogenNames gNEW_MorphogenNames

    if ~isfield( m, 'mgenIndexToName' )
        m.mgenIndexToName = {};
    end
    if m.versioninfo.mgenversion==0
        for i = length(m.mgenIndexToName)+1 : length(gOLD_MorphogenNames)
            m.mgenIndexToName{i} = gOLD_MorphogenNames{i};
        end
    else
        for i = length(m.mgenIndexToName)+1 : length(gNEW_MorphogenNames)
            m.mgenIndexToName{i} = gNEW_MorphogenNames{i};
        end
    end
    if isfield( m, 'morphogens' )
        for i = length(m.mgenIndexToName)+1 : size(m.morphogens,2)
            m.mgenIndexToName{i} = sprintf( 'mgen_%2d', i );
        end
    end
    m.mgenNameToIndex = invertDictionary( m.mgenIndexToName );
end
