function m = calcmeshareas( m )
%m = calcmeshareas( m )
%   Calculate the area of every cell of the mesh.

%   This routine must not assume the existence of any fields except nodes
%   and tricellvxs.  It should set m.cellareas and some components of
%   m.globalProps.

    numcells = size(m.tricellvxs,1);
    if (~isfield( m, 'cellareas' )) || (length( m.cellareas ) ~= numcells)
        m.cellareas = zeros(numcells,1);
    end
    m.cellareas = findFEareas( m );
    if ~isfield( m, 'globalProps' )
        m.globalProps = struct();
    end
    m.globalDynamicProps.currentArea = sum( m.cellareas );
    m.globalDynamicProps.cellscale = sqrt( m.globalDynamicProps.currentArea / numcells );
end

