function  vxstuff = cellToVx( mesh, cellstuff )
%vxstuff = cellToVx( mesh, cellstuff )
%   From an array of stuff-per-cell, construct an array of
%   stuff-per-vertex, setting the quantity at each vertex to be the average
%   of the quantity at each cell the vertex belongs to.
%   The tricellvxs component of the mesh is assumed to be valid.

    numcells = size(mesh.tricellvxs,1);
    numtrivxs = size(mesh.nodes,1);
    vxstuff = zeros(numtrivxs,size(cellstuff,2));
    vxcount = zeros(numtrivxs,1,'int32');
    for i=1:numcells
        vxstuff(mesh.tricellvxs(i,:),:) = ...
            vxstuff(mesh.tricellvxs(i,:),:) + cellstuff(i,:);
        vxcount(mesh.tricellvxs(i,:)) = ...
            vxcount(mesh.tricellvxs(i,:)) + 1;
    end
    for i=1:size(vxstuff,2)
        vxstuff(:,i) = vxstuff(:,i) ./ vxcount;
    end
end
