function results_retrieved=copy_experiment_results_back(ProjectName,ExperimentName, StopHandle)
    if nargin<3
        StopHandle=[];
    end
    MiddleName='runs';
    results_retrieved={};
    allerrors=[];
    if nargin<2
        % directory of experiments
        string2=sprintf('plink -pw %s %s@%s ls /%s%s/%s/runs;',...
            getpassword,getyourclustername,getTheClusterNameAddress,getyourclusterdirectory,getyourclustername,ProjectName);
        moviedirectory=sprintf('dir %s/runs',ProjectName);
        [errors,reply,messg]=unixcluster(string2,moviedirectory);
        if exist(fullfile(ProjectName,'runs'))~=7
            mkdir(fullfile(ProjectName,'runs'));
        end
        ind=strfind(messg,10); %newline \n
    else
        if strfind(ExperimentName,'*') 
            % there is a wildcard so find all the matching filenames
            % directory of experiments
%             string2=sprintf('plink -pw %s %s@escluster.uea.ac.uk cd /%s%s/; ls %s/movies/%s;',...
%                 getpassword,getyourclustername,getyourclusterdirectory,getyourclustername,ProjectName,ExperimentName);
            string2=sprintf('plink -pw %s %s@%s ls /%s%s/%s/runs;',...
                getpassword,getyourclustername,getTheClusterNameAddress,getyourclusterdirectory,getyourclustername,ProjectName);
            moviedirectory=sprintf('dir %s',fullfile(ProjectName,'runs',ExperimentName));
            [errors,reply,messg]=unixcluster(string2,moviedirectory);
            if exist(fullfile(ProjectName,'runs'))~=7
                mkdir(fullfile(ProjectName,'runs'));
            end
            ind=strfind(messg,ExperimentName(1:end-1)); %newline \n
%             ind=strfind(messg,[ProjectName,'/movies']); %newline \n
%             minlength=length(fullfile(ProjectName,'/movies'));
            counter=0;
            for i=1:length(ind)
                tempmessg=messg(ind(i):end);
                endline=strfind(tempmessg,[':',10]);
                if isempty(endline)
                    indx=strfind(tempmessg,10);
                    if isempty(indx)
                        ss{i}=tempmessg;
                    else % assume newline is at the end
                        ss{i}=tempmessg(1:indx-1);
                    end
                else
                    ss{i}=tempmessg(start:endline-1);
                end
                counter=counter+1;
%                 if length(temp1messg)>minlength
%                     start=strfind(tempmessg,'movies')+length('movies')+1;
%                     ss{i}=tempmessg(start:endline-1);
%                     counter=counter+1;
%                 else 
%                     break
%                 end
            end
            ind=1:counter;
            messg='';
        else
            if strcmp(ExperimentName(end-3:end),'_000')
                messg=ExperimentName(1:end-4);
            else
                messg=ExperimentName;
            end
            ind=length(messg)+1;
        end
    end
    start=1;
    for i=1:length(ind)
        if isempty(messg)
            s=ss{ind(i)};
        else
            s=messg(start:ind(i)-1);
        end
        ExperimentName=strtrim(s);
        start=ind(i)+1;
        disp(sprintf('copying the files in %s',ExperimentName));
        string2=sprintf('plink -pw %s %s@%s ls /%s%s/%s/runs/%s/meshes;',...
            getpassword,getyourclustername,getTheClusterNameAddress,getyourclusterdirectory,getyourclustername,ProjectName,ExperimentName);
        moviedirectory=sprintf('dir %s/runs',ProjectName);
        [errors2,reply2,messg2]=unixcluster(string2,moviedirectory);
        % make the requisite directory in runs
        n=fullfile(ProjectName,'runs',ExperimentName);
        if exist(n)~=7
            mkdir(n);
        end
        if exist(fullfile(ProjectName,'runs',ExperimentName,'meshes'))~=7
            mkdir(fullfile(ProjectName,'runs',ExperimentName,'meshes'));
        end
        % copy the metadata files for the experiment
        string=sprintf('pscp -r -pw %s "%s@%s:/%s%s/%s/%s/%s/*.txt" "%s"',...
                getpassword,getyourclustername,getTheClusterNameAddress,getyourclusterdirectory,getyourclustername,ProjectName,MiddleName,ExperimentName,...
                fullfile(ProjectName,MiddleName,ExperimentName));
        [errors,clusterreplya, clusterreplyb]=unixcluster(string,...
            sprintf('Copying metadata file back to windows %s',ExperimentName));
        string2=sprintf('plink -pw %s %s@%s rm -rf /%s%s/%s/runs/%s/*.txt;',...
            getpassword,getyourclustername,getTheClusterNameAddress,getyourclusterdirectory,getyourclustername,ProjectName,ExperimentName);        
        [errors,clusterreplya, clusterreplyb]=unixcluster(string2,...
            sprintf('Removing metadata already copied %s',ExperimentName));
        allerrors=false;
        MiddleName='runs';
        ind2=strfind(messg2,10); %newline \n
        start2=1;
        kk=0;
        for j=1:length(ind2)
            if ~isempty(StopHandle)
                bkc=get(StopHandle,'BackgroundColor');
                if bkc(1)==1
                    break
                end
            end
            s2=strtrim(messg2(start2:ind2(j)-1));
            start2=ind2(j)+1;
            disp(sprintf('copying file %s %s',ExperimentName,s2));
            string=sprintf('pscp -r -pw %s "%s@%s:/%s%s/%s/%s/%s/meshes/%s" "%s"',...
                getpassword,getyourclustername,getTheClusterNameAddress,getyourclusterdirectory,getyourclustername,ProjectName,MiddleName,ExperimentName,s2,...
                fullfile(ProjectName,MiddleName,ExperimentName,'meshes',s2));
            [errors,clusterreplya, clusterreplyb]=unixcluster(string,...
                sprintf('Copying %s:%s file back to windows ',ExperimentName,s2));
            allerrors=allerrors | errors;
            if ~errors
                kk=kk+1;
                results_retrieved{kk}=fullfile(ExperimentName,'meshes',s2);
                string2=sprintf('plink -pw %s %s@%s rm -f /%s%s/%s/%s/%s/meshes/%s;',...
                    getpassword,getyourclustername,getTheClusterNameAddress,getyourclusterdirectory,getyourclustername,ProjectName,MiddleName,ExperimentName,s2);
                %             string='plink -pw .laserBOAT.#2506 ab@escluster.uea.ac.uk cd /gpfs_esscratch01/sys/ab/canvas_snap_081031b; rm -r movies';
                errors=unixcluster(string2,sprintf('deleting % from cluster ',s2));
            end
        end
        if ~isempty(StopHandle)
            if ishandle(StopHandle)
                bkc=get(StopHandle,'BackgroundColor');
                if bkc(1)==1
                    break
                end
            end
        end
    end
end
