function createMeshParamInfo()
% mkparams( internal name, user name, default value, x, y )

    global MESH_PARAMS;

    MESH_PARAMS.circle = struct( ...
        'menuname', 'Circle', ...
        'xwidth',    mkparams( 'X wd.',  2, 1, 1, deescape( 'Diameter in X direction.' ) ), ...
        'ywidth',    mkparams( 'Y wd.',  2, 1, 2, deescape( 'Diameter in Y direction.' ) ), ...
        'circumpts', mkparams( 'Circum', 0, 2, 1, deescape( 'Number of divisions\naround the circumference.' ) ), ...
        'rings',     mkparams( 'Rings',  4, 3, 1, deescape( 'Number of rings of\nfinite elements.' ) ), ...
        'innerpts',  mkparams( 'Inner',  0, 3, 2, deescape( 'Number of elements in\nthe innermost ring.' ) ), ...
        'dealign',   mkparams( '',       0, 0, 0, '' ), ...
        'height',    mkparams( '',       0, 0, 0, deescape( 'Generate a hemispherical surface.' ) ), ...
        'version',   mkparams( '',       0, 0, 0, '' ) ...
        );

    MESH_PARAMS.semicircle = struct( ...
        'menuname', 'Semicircle', ...
        'xwidth',    mkparams( 'X wd.',  2, 1, 1, deescape( 'Diameter in X direction.' ) ), ...
        'ywidth',    mkparams( 'Y wd.',  2, 1, 2, deescape( 'Diameter in Y direction.' ) ), ...
        'circumpts', mkparams( 'Circum', 0, 2, 1, deescape( 'Number of divisions\naround the circumference.' ) ), ...
        'rings',     mkparams( 'Rings',  4, 3, 1, deescape( 'Number of rings of\nfinite elements.' ) ), ...
        'innerpts',  mkparams( 'Inner',  0, 3, 2, deescape( 'Number of elements in\nthe innermost ring.' ) ), ...
        'dealign',   mkparams( '',       0, 0, 0, '' ), ...
        'height',    mkparams( '',       0, 0, 0, deescape( 'Generate a hemidemispherical surface.' ) ), ...
        'version',   mkparams( '',       0, 0, 0, '' ) ...
        );

    MESH_PARAMS.hemisphere = struct( ...
        'menuname', 'Hemisphere', ...
        'constructor', 'circle', ...
        'xwidth',    mkparams( 'X wd.',  2, 1, 1, deescape( 'Diameter in X direction.' ) ), ...
        'ywidth',    mkparams( 'Y wd.',  2, 1, 2, deescape( 'Diameter in Y direction.' ) ), ...
        'circumpts', mkparams( 'Circum', 0, 2, 1, deescape( 'Number of divisions\naround the circumference.' ) ), ...
        'height',    mkparams( 'Height', 1, 2, 2, deescape( 'Height of hemisphere as a proportion of base radius.' ) ), ...
        'rings',     mkparams( 'Rings',  4, 3, 1, deescape( 'Number of rings of\nfinite elements.' ) ), ...
        'innerpts',  mkparams( 'Inner',  0, 3, 2, deescape( 'Number of elements in\nthe innermost ring.' ) ), ...
        'dealign',   mkparams( '',       0, 0, 0, '' ), ...
        'version',   mkparams( '',       0, 0, 0, '' ) ...
        );

    MESH_PARAMS.lobes = struct( ...
        'menuname', 'Lobes', ...
        'radius', mkparams( 'Radius', 2, 1, 1, deescape( 'Radius of lobes.' ) ), ...
        'rings', mkparams( 'Rings', 3, 1, 2, deescape( 'Number of rings of finite\nelements in each lobe.' ) ), ...
        'height', mkparams( 'Height', 0.3, 2, 1, deescape( 'Height of the rectangular\npart of each lobe' ) ), ...
        'strips', mkparams( 'Strips', 0, 2, 2, deescape( 'Number of strips of finite elements the\nrectangular part is divided into.' ) ), ...
        'lobes', mkparams( 'Lobes', 2, 3, 1, deescape( 'Number of lobes.' ) ), ...
        'base', mkparams( 'Base', 0, 3, 2, '' ), ...
        'cylinder', mkparams( '', 0, 0, 0, '' ), ...
        'version', mkparams( '', 0, 0, 0, '' ) ...
        );

    MESH_PARAMS.lune = struct( ...
        'menuname', 'Lune', ...
        'xwidth', mkparams( 'X wd.', 4, 1, 1, '' ), ...
        'ywidth', mkparams( 'Y wd.', 4, 1, 2, '' ), ...
        'xdivs', mkparams( 'X divs', 4, 2, 1, '' ), ...
        'version', mkparams( '', 0, 0, 0, '' ) ...
        );

    MESH_PARAMS.rectangle = struct( ...
        'menuname', 'Rectangle', ...
        'xwidth', mkparams( 'X wid.', 2, 1, 1, deescape( 'Width in the X direction.' ) ), ...
        'ywidth', mkparams( 'Y wid.', 2, 1, 2, deescape( 'Width in the Y direction.' ) ), ...
        'xdivs', mkparams( 'X cells', 4, 2, 1, deescape( 'Number of finite elements\nin the X direction.' ) ), ...
        'ydivs', mkparams( 'Y cells', 4, 2, 2, deescape( 'Number of finite elements\nin the Y direction.' ) ), ...
        'base', mkparams( 'Base', 0, 3, 2, deescape( 'Number of FEs in the X direction\nalong the side of minimum Y.' ) ), ...
        'version', mkparams( '', 0, 0, 0, '' ) ...
        );

    MESH_PARAMS.oneelement = struct( ...
        'menuname', 'One element', ...
        'constructor', 'onecell', ...
        'xwidth', mkparams( 'X wid.', 2, 1, 1, deescape( 'Width in the X direction.' ) ), ...
        'ywidth', mkparams( 'Y wid.', sqrt(3), 1, 2, deescape( 'Width in the Y direction.' ) ), ...
        'version', mkparams( '', 0, 0, 0, '' ) ...
        );

    MESH_PARAMS.cylinder = struct( ...
        'menuname', 'Cylinder', ...
        'xwidth', mkparams( 'X wd.', 2, 1, 1, deescape( 'Diameter of the cylinder in the X direction.' ) ), ...
        'ywidth', mkparams( 'Y wd.', 2, 1, 2, deescape( 'Diameter of the cylinder in the Y direction.' ) ), ...
        'circumdivs', mkparams( 'Cells', 12, 2, 1, deescape( 'Number of FEs around.' ) ), ...
        'height', mkparams( 'Height', 2, 3, 1, deescape( 'Height of the cylinder.' ) ), ...
        'heightdivs', mkparams( 'Cells', 4, 3, 2, deescape( 'Number of FEs tall.' ) ), ...
        'basecap', mkparams( '', 0, 0, 0, '' ), ...
        'topcap', mkparams( '', 0, 0, 0, '' ), ...
        'version', mkparams( '', 0, 0, 0, '' ) ...
        );

    MESH_PARAMS.cup = struct( ...
        'menuname', 'Cup', ...
        'constructor', 'cylinder', ...
        'xwidth', mkparams( 'X wd.', 2, 1, 1, deescape( 'Diameter of the cylinder in the X direction.' ) ), ...
        'ywidth', mkparams( 'Y wd.', 2, 1, 2, deescape( 'Diameter of the cylinder in the Y direction.' ) ), ...
        'height', mkparams( 'Height', 2, 1, 3, deescape( 'Height of the cylindrical part.' ) ), ...
        'circumdivs', mkparams( 'Cells', 12, 2, 1, deescape( 'Number of FEs around.' ) ), ...
        'baseheight', mkparams( 'Base ht', 1, 2, 3, deescape( 'Height of the base cap as\na proportion of radius.' ) ), ...
        'heightdivs', mkparams( 'Cells', 4, 3, 1, deescape( 'Number of FEs tall.' ) ), ...
        'baserings', mkparams( 'Base rg', 0, 3, 3, deescape( 'Number of rings of FEs\nin the base cap.' ) ), ...
        'basecap', mkparams( '', 1, 0, 0, '' ), ...
        'topcap', mkparams( '', 0, 0, 0, '' ), ...
        'version', mkparams( '', 0, 0, 0, '' ) ...
        );

    MESH_PARAMS.cap = struct( ...
        'menuname', 'Cap', ...
        'constructor', 'cylinder', ...
        'xwidth', mkparams( 'X wd.', 2, 1, 1, deescape( 'Diameter of the cylinder in the X direction.' ) ), ...
        'ywidth', mkparams( 'Y wd.', 2, 1, 2, deescape( 'Diameter of the cylinder in the Y direction.' ) ), ...
        'height', mkparams( 'Height', 2, 1, 3, deescape( 'Height of the cylindrical part.' ) ), ...
        'circumdivs', mkparams( 'Cells', 12, 2, 1, deescape( 'Number of FEs around.' ) ), ...
        'topheight', mkparams( 'Top ht', 1, 2, 2, deescape( 'Height of the top cap as\na proportion of radius.' ) ), ...
        'heightdivs', mkparams( 'Cells', 4, 3, 1, deescape( 'Number of FEs tall.' ) ), ...
        'toprings', mkparams( 'Top rg', 0, 3, 2, deescape( 'Number of rings of FEs\nin the top cap.' ) ), ...
        'basecap', mkparams( '', 0, 0, 0, '' ), ...
        'topcap', mkparams( '', 1, 0, 0, '' ), ...
        'version', mkparams( '', 0, 0, 0, '' ) ...
        );

    MESH_PARAMS.capsule = struct( ...
        'menuname', 'Capsule', ...
        'constructor', 'cylinder', ...
        'xwidth', mkparams( 'X wd.', 2, 1, 1, deescape( 'Diameter of the cylinder in the X direction.' ) ), ...
        'ywidth', mkparams( 'Y wd.', 2, 1, 2, deescape( 'Diameter of the cylinder in the Y direction.' ) ), ...
        'height', mkparams( 'Height', 2, 1, 3, deescape( 'Height of the cylindrical part.' ) ), ...
        'circumdivs', mkparams( 'Cells', 12, 2, 1, deescape( 'Number of FEs around.' ) ), ...
        'topheight', mkparams( 'Top ht', 1, 2, 2, deescape( 'Height of the top cap as\na proportion of radius.' ) ), ...
        'baseheight', mkparams( 'Base ht', 1, 2, 3, deescape( 'Height of the base cap as\na proportion of radius.' ) ), ...
        'heightdivs', mkparams( 'Cells', 4, 3, 1, deescape( 'Number of FEs tall.' ) ), ...
        'toprings', mkparams( 'Top rg', 0, 3, 2, deescape( 'Number of rings of FEs\nin the top cap.' ) ), ...
        'baserings', mkparams( 'Base rg', 0, 3, 3, deescape( 'Number of rings of FEs\nin the base cap.' ) ), ...
        'basecap', mkparams( '', 1, 0, 0, '' ), ...
        'topcap', mkparams( '', 1, 0, 0, '' ), ...
        'version', mkparams( '', 0, 0, 0, '' ) ...
        );

    MESH_PARAMS.snapdragon = struct( ...
        'menuname', 'Snapdragon', ...
        'radius', mkparams( 'Radius', 2, 1, 1, deescape( 'Radius of the cylindrical\npart of the snapdragon.' ) ), ...
        'rings', mkparams( 'Rings', 2, 1, 2, deescape( 'Number of rings of FEs in each lobe.' ) ), ...
        'bowl', mkparams( 'Bowl', 0.5, 1, 3, deescape( 'Depth of the hemispherical base\ncap as a proportion of radius.' ) ), ...
        'height', mkparams( 'Height', 0.3, 2, 1, deescape( 'Height of the cylindrical part.' ) ), ...
        'strips', mkparams( 'Strips', 0, 2, 2, deescape( 'Number of horizontal strips of\nFEs in the cylindrical part.' ) ), ...
        'baserings', mkparams( 'BowlRg', 0, 2, 3, deescape( 'Number of rings of FEs in the base cap.' ) ), ...
        'petals', mkparams( 'Petals', 5, 3, 1, deescape( 'Number of lobes.' ) ), ...
        'base', mkparams( 'Base', 0, 3, 2, deescape( 'Number of FEs around the circumference\nof the base, per half-lobe.' ) ), ...
        'version', mkparams( '', 0, 0, 0, '' ) ...
        );

    MESH_PARAMS.icosahedron = struct( ...
        'menuname', 'Icosahedron', ...
        'radius', mkparams( 'Radius', 1, 1, 1, deescape( 'Radius of the icosahedron.' ) ), ...
        'version', mkparams( '', 0, 0, 0, '' ) ...
        );
end

function p = mkparams( name, dft, row, col, tooltip )
    p = struct( 'guiname', name, ...
                'default', dft, ...
                'row', row, ...
                'col', col, ...
                'tooltip', tooltip );
end

