function m = makeAreasAndNormals( m, cells )
%m = makeAreasAndNormals( m, cells )
%   Compute the normal vector and area of the given finite elements, by
%   default all of them.  We do these
%   together, since this is faster than computing them separately.

    if nargin < 2
        [m.cellareas,m.unitcellnormals] = ...
            triangleareas( m.nodes, m.tricellvxs );
    else
        [m.cellareas(cells),m.unitcellnormals(cells,:)] = ...
            triangleareas( m.nodes, m.tricellvxs, cells );
    end

    m.globalDynamicProps.currentArea = sum( m.cellareas );
    m.globalDynamicProps.cellscale = sqrt( m.globalDynamicProps.currentArea / length(m.cellareas) );
end
