function m = makeprismsvalid( m )
%m = makeprismsvalid( m )
%    Convert 2Dmesh to 3D set of prisms.

    if m.globalProps.prismnodesvalid, return; end
    if ~m.globalProps.trinodesvalid, return; end
    
    m = makeAreasAndNormals( m );

    if m.globalDynamicProps.thicknessAbsolute==0
        m = setThickness( m );
    end

    m.prismnodes = ...
        reshape( ...
            [ m.nodes(:,1:2)'; ...
              m.nodes(:,3)' - m.globalDynamicProps.thicknessAbsolute/2;
              m.nodes(:,1:2)'; ...
              m.nodes(:,3)' + m.globalDynamicProps.thicknessAbsolute/2 ], ...
          3, size(m.nodes,1)*2 )';
    m = rectifyVerticals(m);
    if size(m.prismnodes,1) ~= 2*size(m.nodes,1)
        fprintf( 1, 'makeprismsvalid: bad sizes %d %d\n', ...
            size(m.prismnodes,1), size(m.nodes,1) );
        error(' ');
    end
    m.globalProps.prismnodesvalid = true;
end
