function m = recordframe( m, frame )
    if ~m.globalProps.makemovie
        return;
    end
    if nargin < 2
        frame = leaf_getimage( m );
    end
    if isempty( frame )
        return;
    end

    m=leaf_record_mesh_frame(m);
    try
        m.globalProps.mov = addmovieframe( m.globalProps.mov, frame );
        fprintf( 1, 'Recording movie frame at time %f, iteration %f.\n', ...
            m.globalDynamicProps.currenttime, m.globalDynamicProps.currentIter );
    catch
        e = lasterror();
        GFtboxAlert( 1, 'Could not add frame to movie.\n%s', ...
            e.message );
        try
            m.globalProps.mov = closemovie( m.globalProps.mov );
        catch
        end
        m.globalProps.mov = [];
        m.globalProps.makemovie = 0;
    end
end
