function mesh = refinemesh( mesh, frac )
%mesh = refinemesh( mesh, frac )    Refine a mesh by splitting every edge
%   which is at least as long as the shortest of the longest frac of the
%   edges.
    if frac <= 0, return; end
    lengthsqs = edgelengthsqs(mesh);
    numedges = size( mesh.edgeends, 1 );
    if numedges==0, return; end
    [sortedlen,sortperm] = sort( -lengthsqs' );
    e = ceil(numedges*frac);
    if e <= 0, e = 1; end
    if e > numedges, e = numedges; end
    mesh = splitalledges( mesh, sortperm( 1:e ), true );
    mesh = makeedgethreshsq( mesh );
end
