function sl = newemptysecondlayer()
%sl = newemptysecondlayer()
%   Create a second layer containing no cells.

% The second layer contains the following information:
% For each clone cell ci:
%       cells(ci).vxs(:)       A list of all its vertexes, in clockwise order.
%       cells(ci).edges(:)     A list of all its edges, in clockwise order.
%           These cannot be 2D arrays, since different cells may have
%           different numbers of vertexes or edges.
%       cellcolor(ci,1:3):     Its colour.
%       side(ci)               True if it should be plotted on the A side.
%       cloneindex(ci)         Its clone number.
%       cellarea(ci)           Its current area.
%       celltargetarea(ci)     ??
%       areamultiple(ci)       ??
% For each clone vertex vi:
%       vxFEMcell(vi)          Its FEM cell index.
%       vxBaryCoords(vi,1:3)   Its FEM cell barycentric coordinates.
%       cell3dcoords(vi,1:3)   Its 3D coordinates (which can be calculated
%                              from the other data).
% For each clone edge ei:
%       edges(ei,1:4)          The indexes of the clone vertexes at its ends
%                              and the clone cells on either side (the
%                              second one is 0 if absent).  This can be
%                              computed from the other data.
%       generation(ei)         Its generation number, used in order to
%                              colour new edges differently from old ones.
%
% Other componentsL:
%       splitThreshold         A single real number.
%       jiggleAmount           A single real number.
%       averagetargetarea      A single real number.

    sl = [];
    sl.splitThreshold = 0;
    sl.cells = [];
    sl.cellcolor = zeros(0,3, 'single');
    sl.vxFEMcell = zeros(0,1, 'int32');
    sl.vxBaryCoords = zeros(0,3, 'single');
    sl.cell3dcoords = zeros(0,3, 'single');
    sl.edges = zeros(0,4);
    sl.side = true(0);
    sl.cloneindex = int32([]);
    sl.generation = int32([]);
end
