function bc1 = perturbBaryCoords( bc, amount )
%bc1 = perturbBaryCoords( bc )    Randomly perturb the given barycentric
%coordinates, while keeping them all in the range 0..1 with sum equal to 1.

% 0.5774 is 1/sqrt(3).
    bc1 = 0.5774 * amount * (rand(size(bc)) - bc) + bc;
    bc1 = max(bc1,0);
    bc1 = min(bc1,1);
    bc1 = bc1/sum(bc1);
end
