function selectPanel( handles, panels, panelname )
    panelnames = fieldnames(panels);
    for i=1:length(panelnames)
        if ~strcmp(panelnames{i},panelname)
            pname = strcat( panelnames{i}, 'panel' );
            if get( handles.(pname), 'Visible' );
                set( handles.(pname), 'Visible', 'off' );
            end
        end
    end
    drawnow;
    pname = strcat( panelname, 'panel' );
    set( handles.(pname), 'Visible', 'on' );
    % Force redraw -- some machines don't redraw the controls.
    if true || (isfield( handles, 'aggressiveRedraw' ) && handles.aggressiveRedraw)
        drawnow;
    end
    % More aggressive method:
    % GFTwindow_ResizeFcn( handles.output, [], handles );
end
