function m = setAbsoluteThickness( m, thickness )
%m = setAbsoluteThickness( m, thickness )
%   Set the current absolute thickness of the mesh everywhere.
%   The thickness parameters are not affected.  This procedure should only
%   be used when thickness is implemented physically.

    numpnodes = size( m.prismnodes, 1 );
    anodes = 1:2:(numpnodes-1);
    bnodes = 2:2:numpnodes;
    delta = m.prismnodes( anodes, : ) - m.prismnodes( bnodes, : );
    len = sqrt(sum( delta.*delta, 2 ));
    oklen = len > 0;
    anodes = anodes(oklen);
    bnodes = bnodes(oklen);
    len = len(oklen);
    delta = delta(oklen,:);
    ratios = (thickness./len - 1)/2;
    for i=1:size(delta,2)
        delta(:,i) = delta(:,i).*ratios;
    end
    m.prismnodes( anodes, : ) = m.prismnodes( anodes, : ) + delta;
    m.prismnodes( bnodes, : ) = m.prismnodes( bnodes, : ) - delta;
end
