function mesh = setNumMorphogens( mesh, n )
%mesh = setNumMorphogens( mesh, n )
%   Set the number of morphogens of the mesh, either discarding excess
%   morphogens or creating new ones.

    curNum = size( mesh.morphogens, 2 );
    mesh.morphogens = procrustesWidth( mesh.morphogens, n );
    mesh.morphogenclamp = procrustesWidth( mesh.morphogenclamp, n );
    mesh.absKvector = procrustesWidth( mesh.absKvector, n );
    if n < curNum
        if mesh.globalProps.activeGrowth > n
            mesh.globalProps.activeGrowth = n;
        end
        if mesh.globalProps.displayedGrowth > n
            mesh.globalProps.displayedGrowth = n;
        end
    end
%    fprintf( 1, 'setNumMorphogens( %d ), size now %d %d\n', ...
%        n, size(mesh.morphogens) );
end
