function singlestep_Callback(hObject, eventdata, handles)
% --- Executes on button press in singlestep.
% hObject    handle to singlestep (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    if nargin < 3
      % fprintf( 1, '%s: A strange event occurred!  Nargin = %d.\n', ...
      %     mfilename, nargin );
        return;
    end
    if isempty( handles.mesh )
        fprintf( 1, 'No mesh.\n' );
    elseif get( handles.runFlag, 'Value' )
        % WARNING: Should ask user.
        beep;
    else
        oldCursor = get(gcf,'Pointer');
        set(gcf,'Pointer','watch');
        handles.mesh.globalProps.maxIters = ...
            handles.mesh.globalDynamicProps.currentIter + 1;
        announceSimStatus( handles );
        setRunning( handles, 1 );
        handles.mesh = leaf_iterate( handles.mesh, ...
            1, 'plot', 1, 'handles', handles );
        % leaf_iterate handles the recording of the command itself.
        setRunning( handles, 0 );
        guidata(hObject, handles);
        set(gcf,'Pointer',oldCursor);
    end


